var samplePageObj = {
  // 샘플 타이틀
  title: '열계산식',
  subtitle: '시트 생성시 미리 부여한 로직에 의해 컬럼의 값이 자동으로 계산 됩니다.',
  // 샘플 설명
  desc: '컬럼별 Formula 를 설정하여 간단한 4칙 연산부터 javascript 에서 지원하는 수학적 함수를 사용한 계산결과도 표시할 수 있습니다.<br>'
    + 'Formula 사용하기 위해서는 기본적으로 (Row)CanFormula 속성이 설정되어 있어야 합니다. ',

  // 객체 초기화 구문
  init: {
    Def: {
      Header: {
        Visible: 1 // 헤더 로우의 Visible 상태 변경 설정 {0:숨김, 1:보임}
      },
      Row: {
        CanFormula: 1,
        AlternateColor: '#CCDDE4'
      },
      Col: {
        MinWidth: '90',
        Format: '#,##0.##'
      }
    },

    Cfg: {
      SearchMode: 0,
      Alternate: 2,
      SelectionSummary: {
        Mode: 'DelRow',
        Width: 400
      },
      InfoRowConfig: {
        Visible: 1,
        Layout: [
          'SummaryLabel',
          'Count'
        ],
        Space: 'Top'
      }// 건수 정보 표시
    },
    Cols: [
      {
        Header: '번호',
        Type: 'Text',
        Name: 'SEQ',
        Width: 50,
        MaxWidth: 50
      },
      {
        Header: 'X',
        Type: 'Int',
        Name: 'X',
        RelWidth: 1
      },
      {
        Header: 'Y',
        Type: 'Int',
        Name: 'Y',
        RelWidth: 1
      },
      {
        Header: 'A=X+Y',
        Type: 'Int',
        Name: 'A',
        Formula: plusFormula,
        RelWidth: 1
      },
      {
        Header: 'B=X-Y',
        Type: 'Int',
        Name: 'B',
        Formula: minusFormula,
        RelWidth: 1
      },
      {
        Header: 'C=X*Y',
        Type: 'Int',
        Name: 'C',
        Formula: multiplicationFormula,
        RelWidth: 1
      },
      {
        Header: 'D=X/Y',
        Type: 'Int',
        Name: 'D',
        Formula: divideFormula,
        RelWidth: 1
      },
      {
        Header: 'E=D-(D*0.9)',
        Type: 'Int',
        Name: 'E',
        Formula: multiminusFormula,
        RelWidth: 1
      },
      {
        Header: 'F=(X+1)^3',
        Type: 'Int',
        Name: 'F',
        MinWidth: '130',
        Formula: SquaredFormula,
        RelWidth: 1
      },
      {
        Header: 'G=√(X²+Y²)',
        Type: 'Int',
        Name: 'G',
        Formula: sqrtFormula,
        RelWidth: 1
      },
      {
        Header: 'H=G>20?G:0',
        Type: 'Int',
        Name: 'H',
        Formula: 'userFormula',
        RelWidth: 1
      },
    ],
  },
  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '',
  // 외부함수 "화면기능 텝"에서 보여지게 됨
  externalFunction: {
    userFormula: function (formula) {
      var val;

      // G 컬럼의 값이 >20 이상인 경우 해당 컬럼값 표시
      val = formula.Row.G > 20 ? formula.Row.G : 0;

      return val;
    }

  },

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      X: '10',
      Y: '1'
    },
    {
      X: '3',
      Y: '4'
    },
    {
      X: '12',
      Y: '8'
    },
    {
      X: '2',
      Y: '4'
    },
    {
      X: '-5',
      Y: '10'
    },
    {
      X: '8',
      Y: '-20'
    },
    {
      X: '35',
      Y: '7'
    },
    {
      X: '7',
      Y: '2'
    },
    {
      X: '62',
      Y: '26'
    },
    {
      X: '-15',
      Y: '-2'
    },
    {
      X: '41',
      Y: '12'
    },
    {
      X: '-33',
      Y: '-66'
    },
    {
      X: '0',
      Y: '19'
    },
    {
      X: '25',
      Y: '22'
    },
    {
      X: '6',
      Y: '-12'
    },
    {
      X: '17',
      Y: '5'
    },
    {
      X: '-13',
      Y: '-1'
    },
    {
      X: '-22',
      Y: '34'
    },
  ]

};
// 실제 처리는 여기서
var userFormula = function (formula) {
  var val;

  // G 컬럼의 값이 >20 이상인 경우 해당 컬럼값 표시
  val = formula.Row.G > 20 ? formula.Row.G : 0;

  return val;
};

function plusFormula(fr) {
  return fr.Row.X + fr.Row.Y;
}

function minusFormula(fr) {
  return fr.Row.X - fr.Row.Y;
}

function multiplicationFormula(fr) {
  return fr.Row.X * fr.Row.Y;
}

function divideFormula(fr) {
  return fr.Row.X / fr.Row.Y;
}

function multiminusFormula(fr) {
  return fr.Row.D - (fr.Row.D * 0.9);
}

function SquaredFormula(fr) {
  return (fr.Row.X + 1) ^ 3;
}

function sqrtFormula(fr) {
  return Math.sqrt(fr.Row.X * fr.Row.X + fr.Row.Y * fr.Row.Y);
}
